#ifndef __PROFIBUS_FSPMM2_ERROR_H
#define __PROFIBUS_FSPMM2_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS Master FSPMM2 Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_PROFIBUS_FSPMM2_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_PROFIBUS_FSPMM2_COMMAND_INVALID ((TLR_RESULT)0xC0690000L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_LENGTH_INVALID
//
// MessageText:
//
//  Invalid data length.
//
#define TLR_E_PROFIBUS_FSPMM2_LENGTH_INVALID ((TLR_RESULT)0xC0690001L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_NOT_IMPLEMENTED
//
// MessageText:
//
//  Service not implemented.
//
#define TLR_E_PROFIBUS_FSPMM2_NOT_IMPLEMENTED ((TLR_RESULT)0xC0690002L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_ADD_INVALID
//
// MessageText:
//
//  Invalid address.
//
#define TLR_E_PROFIBUS_FSPMM2_ADD_INVALID ((TLR_RESULT)0xC0690003L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_SERVICE_IN_REQUEST
//
// MessageText:
//
//  Previous service already in request.
//
#define TLR_E_PROFIBUS_FSPMM2_SERVICE_IN_REQUEST ((TLR_RESULT)0xC0690004L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_NOT_IN_OPEN_STATE
//
// MessageText:
//
//  Connection is not in state open.
//
#define TLR_E_PROFIBUS_FSPMM2_NOT_IN_OPEN_STATE ((TLR_RESULT)0xC0690005L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_OUT_OF_RESOURCES
//
// MessageText:
//
//  Out of resources for new connections.
//
#define TLR_E_PROFIBUS_FSPMM2_OUT_OF_RESOURCES ((TLR_RESULT)0xC0690006L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_IN_USE
//
// MessageText:
//
//  Connection to this slave already in use.
//
#define TLR_E_PROFIBUS_FSPMM2_IN_USE     ((TLR_RESULT)0xC0690007L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_ALREADY_INIT
//
// MessageText:
//
//  Stack is already initialized.
//
#define TLR_E_PROFIBUS_FSPMM2_ALREADY_INIT ((TLR_RESULT)0xC0690008L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_COM_REFERENCE_INVALID
//
// MessageText:
//
//  Invalid communication reference.
//
#define TLR_E_PROFIBUS_FSPMM2_COM_REFERENCE_INVALID ((TLR_RESULT)0xC0690009L)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_TIMEOUT
//
// MessageText:
//
//  Timout error.
//
#define TLR_E_PROFIBUS_FSPMM2_TIMEOUT    ((TLR_RESULT)0xC069000AL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_INITIATE_ABT_STO
//
// MessageText:
//
//  Parameter Send Timeout to small.
//
#define TLR_E_PROFIBUS_FSPMM2_INITIATE_ABT_STO ((TLR_RESULT)0xC069000BL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_INITIATE_ABT_FE
//
// MessageText:
//
//  Telegram format error.
//
#define TLR_E_PROFIBUS_FSPMM2_INITIATE_ABT_FE ((TLR_RESULT)0xC069000CL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_NRS
//
// MessageText:
//
//  Negativ response.
//
#define TLR_E_PROFIBUS_FSPMM2_NRS        ((TLR_RESULT)0xC069000DL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_ABORT
//
// MessageText:
//
//  Service Aborted.
//
#define TLR_E_PROFIBUS_FSPMM2_ABORT      ((TLR_RESULT)0xC069000EL)

//
// MessageId: TLR_E_PROFIBUS_FSPMM2_CON_XX
//
// MessageText:
//
//  Service confirmation negative.
//
#define TLR_E_PROFIBUS_FSPMM2_CON_XX     ((TLR_RESULT)0xC0690100L)




#endif  //__PROFIBUS_FSPMM2_ERROR_H

